/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWPrintableProperty;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class VWPrintableWorkflowCollectionProperty
extends VWPrintableProperty {
    protected static final Image PROPERTIES_ICON = VWImageLoader.createImageIcon("collectionProperties.gif").getImage();
    protected VWWorkflowCollectionDefinition m_wflCollectionDef = null;

    public VWPrintableWorkflowCollectionProperty(VWWorkflowCollectionDefinition wflCollectionDef, Graphics g, VWPrinter printer) {
        super(g, printer);
        this.m_wflCollectionDef = wflCollectionDef;
    }

    protected void renderPage(Graphics2D g2, PageFormat pf, int idx) throws PrinterException {
        Point p = new Point(0, 0);
        ArrayList page = this.getPage(idx - this.m_startingPage);
        for (String line : page) {
            if (VWStringUtils.compare(line, VWResource.s_packagePropertiesDialogTitle) == 0) {
                this.printTitleLine(PROPERTIES_ICON, line, p);
                continue;
            }
            if (line.startsWith("[[FOOTER]]")) {
                String footer = line.substring("[[FOOTER]]".length());
                this.printFooterLine(footer);
                continue;
            }
            this.printTextLine(line, p);
        }
    }

    protected void repaginate(PageFormat pf) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            this.newChapter(this.m_wflCollectionDef.getName());
            this.appendTitleLine(VWResource.s_packagePropertiesDialogTitle);
            String aLine = VWResource.s_colon.toString(VWResource.s_name) + this.m_wflCollectionDef.getName();
            this.appendTextLine(aLine, 0, false);
            this.printGeneralInfo();
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void printGeneralInfo() throws Exception {
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_general), 0, false);
        String tempString = this.m_wflCollectionDef.getDescription();
        if (tempString != null && tempString.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description), 1, false);
            StringTokenizer st = new StringTokenizer(tempString, "\n");
            while (st.hasMoreTokens()) {
                this.appendTextLine(st.nextToken(), 2, true);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + VWResource.s_none, 1, false);
        }
    }
}

